IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'[dbo].[CF_Cbte_Cob_Permitir]') 
                   and [type] = 'FN')
BEGIN
    DROP FUNCTION dbo.CF_Cbte_Cob_Permitir 
END
GO

CREATE FUNCTION dbo.CF_Cbte_Cob_Permitir   (@Id_Trans INT, @Fecha DATETIME)
RETURNS INT	
AS
BEGIN

/*
Descripcin:Valida si el cbte. se puede cob
Fecha de creacin: 4/12/2018
Auto: GC
Retorno: Retorna cero cuando es habilitada la cobranza
*/


DECLARE @Retorno 	SMALLINT;

/* Valido Cant_Meses_Cobro_Atrasado */

SET @Retorno = ISNULL((Select COUNT(*) from cbtes_items i, Productos P, Prod_Familias F 
                 where I.id_trans = @Id_Trans
                  And P.id_producto = I.Id_Producto 
                  And P.Id_Familia = F.Id_Familia 
                  And ISNULL(F.Cant_Meses_Cobro_Atrasado,0) <> 0 
                  And (I.FECHA_QA + F.Cant_Meses_Cobro_Atrasado) < @Fecha),0)


/* Agregar resto de validaciones aca */


RETURN @Retorno;

END
       
  